class W3Effect_EyeOfTheStorm extends CBaseGameplayEffect
{
	var i					: int;
	var effect1				: CEntity;
	var effect_entity  		: StormEyeSpell;
	var bonenames			: array< name >;
	var effects				: array< CEntity >;
	
	default isPositive = true;
	default isNeutral = false;
	default isNegative = false;
	default effectType = EET_EyeOfTheStorm;
	default attributeName = 'EyeOfTheStorm';
		
	event OnEffectAdded(optional customParams : W3BuffCustomParams)
	{	
		super.OnEffectAdded(customParams);	
		
		bonenames.Clear();
		bonenames.PushBack( 'head' );	
		bonenames.PushBack( 'l_foot' );	
		bonenames.PushBack( 'r_foot' );	
		bonenames.PushBack( 'r_bicep2' );	
		bonenames.PushBack( 'l_bicep2' );	
		bonenames.PushBack( 'r_forearm' );	
		bonenames.PushBack( 'l_forearm' );	
		bonenames.PushBack( 'r_kneeRoll' );	
		bonenames.PushBack( 'l_kneeRoll' );	
		
		effect_entity = (StormEyeSpell)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\eye_of_the_storm.w2ent", true ), 
												target.GetWorldPosition(), target.GetWorldRotation() );
		effect_entity.CreateAttachment( thePlayer, 'quen_sphere' );		
		effect_entity.AddTag('storm_eye_effect');
			
		for( i = 0; i < bonenames.Size(); i += 1 )
		{
			effect1 = target.CreateFXEntityAtBone( 'storm_eye', bonenames[i], true );
			effect1.PlayEffect('trails');
			effects.PushBack(effect1);
		}
		
	}
	
	event OnEffectRemoved()
	{
		super.OnEffectRemoved();
		
		effect_entity.Destroy();
		
		for ( i = 0; i <= effects.Size(); i+=1 )
		{
			//effects[i].StopAllEffects();
			effects[i].DestroyAfter(0.1);
		}
	}
}